/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.accesstransformer.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.accesstransformer.AccessTransformer;
import net.minecraftforge.accesstransformer.ClassTarget;
import net.minecraftforge.accesstransformer.FieldTarget;
import net.minecraftforge.accesstransformer.INameHandler;
import net.minecraftforge.accesstransformer.InnerClassTarget;
import net.minecraftforge.accesstransformer.MethodTarget;
import net.minecraftforge.accesstransformer.WildcardTarget;
import net.minecraftforge.accesstransformer.generated.AtParser;
import net.minecraftforge.accesstransformer.generated.AtParserBaseVisitor;
import net.minecraftforge.accesstransformer.parser.ModifierProcessor;
import org.antlr.v4.runtime.RuleContext;

public class AccessTransformVisitor
extends AtParserBaseVisitor<Void> {
    private final INameHandler nameHandler;
    private List<AccessTransformer> accessTransformers = new ArrayList<AccessTransformer>();
    private final String origin;

    public AccessTransformVisitor(String origin, INameHandler nameHandler) {
        this.origin = origin;
        this.nameHandler = nameHandler;
    }

    @Override
    public Void visitEntry(AtParser.EntryContext ctx) {
        if (ctx.line_value() == null) {
            String className = ctx.class_name().getText();
            String modifier = ctx.keyword().getText();
            className = this.nameHandler.translateClassName(className);
            ClassTarget target = new ClassTarget(className);
            this.accessTransformers.add(new AccessTransformer(target, ModifierProcessor.modifier(modifier), ModifierProcessor.finalState(modifier), this.origin, ctx.getStart().getLine()));
            int idx = className.lastIndexOf(36);
            if (idx != -1) {
                String parent = className.substring(0, idx);
                this.accessTransformers.add(new AccessTransformer(new InnerClassTarget(parent, className.replace('.', '/')), ModifierProcessor.modifier(modifier), ModifierProcessor.finalState(modifier), this.origin, ctx.getStart().getLine()));
            }
        }
        return (Void)super.visitEntry(ctx);
    }

    @Override
    public Void visitFunction(AtParser.FunctionContext ctx) {
        AtParser.EntryContext entry = (AtParser.EntryContext)ctx.getParent().getParent();
        String className = entry.class_name().getText();
        String modifier = entry.keyword().getText();
        String methodName = ctx.func_name().getText();
        className = this.nameHandler.translateClassName(className);
        methodName = this.nameHandler.translateMethodName(methodName);
        List<String> args = ctx.argument().stream().map(RuleContext::getText).collect(Collectors.toList());
        String retVal = ctx.return_value().getText();
        MethodTarget target = new MethodTarget(className, methodName, args, retVal);
        this.accessTransformers.add(new AccessTransformer(target, ModifierProcessor.modifier(modifier), ModifierProcessor.finalState(modifier), this.origin, ctx.getStart().getLine()));
        return (Void)super.visitFunction(ctx);
    }

    @Override
    public Void visitField_name(AtParser.Field_nameContext ctx) {
        AtParser.EntryContext entry = (AtParser.EntryContext)ctx.getParent().getParent();
        String className = entry.class_name().getText();
        String modifier = entry.keyword().getText();
        String fieldName = ctx.getText();
        className = this.nameHandler.translateClassName(className);
        fieldName = this.nameHandler.translateFieldName(fieldName);
        FieldTarget target = new FieldTarget(className, fieldName);
        this.accessTransformers.add(new AccessTransformer(target, ModifierProcessor.modifier(modifier), ModifierProcessor.finalState(modifier), this.origin, ctx.getStart().getLine()));
        return (Void)super.visitField_name(ctx);
    }

    @Override
    public Void visitWildcard_field(AtParser.Wildcard_fieldContext ctx) {
        AtParser.EntryContext entry = (AtParser.EntryContext)ctx.getParent().getParent();
        String className = entry.class_name().getText();
        String modifier = entry.keyword().getText();
        WildcardTarget target = new WildcardTarget(className, false);
        this.accessTransformers.add(new AccessTransformer(target, ModifierProcessor.modifier(modifier), ModifierProcessor.finalState(modifier), this.origin, ctx.getStart().getLine()));
        return (Void)super.visitWildcard_field(ctx);
    }

    @Override
    public Void visitWildcard_method(AtParser.Wildcard_methodContext ctx) {
        AtParser.EntryContext entry = (AtParser.EntryContext)ctx.getParent().getParent();
        String className = entry.class_name().getText();
        String modifier = entry.keyword().getText();
        WildcardTarget target = new WildcardTarget(className, true);
        this.accessTransformers.add(new AccessTransformer(target, ModifierProcessor.modifier(modifier), ModifierProcessor.finalState(modifier), this.origin, ctx.getStart().getLine()));
        return (Void)super.visitWildcard_method(ctx);
    }

    public List<AccessTransformer> getAccessTransformers() {
        return this.accessTransformers;
    }
}

